SELECT TOP 10 L_ORDERKEY,
SUM(dbo.discount_price(L_EXTENDEDPRICE, L_DISCOUNT)) AS REVENUE,
O_ORDERDATE, O_SHIPPRIORITY
FROM CUSTOMER, ORDERS, LINEITEM
WHERE C_CUSTKEY = O_CUSTKEY AND L_ORDERKEY = O_ORDERKEY
AND dbo.q3conditions(C_MKTSEGMENT, O_ORDERDATE, L_SHIPDATE) = 1
GROUP BY L_ORDERKEY, O_ORDERDATE, O_SHIPPRIORITY
ORDER BY REVENUE DESC, O_ORDERDATE;